/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.utils;

import com.terraforged.mod.featuremanager.matcher.dynamic.DynamicMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeBuilder
extends Biome.Builder {
    private final Biome parentBiome;
    private final Map<GenerationStage.Decoration, List<Supplier<ConfiguredFeature<?, ?>>>> features = new EnumMap(GenerationStage.Decoration.class);
    private RegistryKey<Biome> parentKey;
    private BiomeGenerationSettings.Builder settings = new BiomeGenerationSettings.Builder();
    private int weight = -1;
    private BiomeManager.BiomeType type = null;
    private final List<BiomeDictionary.Type> dictionaryTypes = new ArrayList<BiomeDictionary.Type>();

    public BiomeBuilder(RegistryKey<Biome> key, Biome biome) {
        this.parentBiome = biome;
        this.parentKey = key;
        this.dictionaryTypes.addAll(BiomeDictionary.getTypes(this.parentKey));
    }

    public void setParentKey(RegistryKey<Biome> parentKey) {
        this.parentKey = parentKey;
    }

    public RegistryKey<Biome> getParentKey() {
        return this.parentKey;
    }

    public void registerTypes(RegistryKey<Biome> key) {
        this.dictionaryTypes.forEach(type -> BiomeDictionary.addTypes((RegistryKey)key, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{type}));
        BiomeDictionary.addTypes(key, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD});
    }

    public void registerWeight(RegistryKey<Biome> key) {
        if (this.type == null) {
            return;
        }
        if (this.weight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)this.type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, this.weight));
        } else if (BiomeDictionary.getTypes(key).contains(BiomeDictionary.Type.RARE)) {
            BiomeManager.addBiome((BiomeManager.BiomeType)this.type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, 2));
        } else if (BiomeDictionary.getTypes(key).contains(BiomeDictionary.Type.FOREST)) {
            BiomeManager.addBiome((BiomeManager.BiomeType)this.type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, 5));
        } else {
            BiomeManager.addBiome((BiomeManager.BiomeType)this.type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, 10));
        }
    }

    public void type(BiomeManager.BiomeType type) {
        this.type = type;
    }

    public void weight(int weight) {
        this.weight = weight;
    }

    public void setType(BiomeDictionary.Type ... types) {
        this.dictionaryTypes.clear();
        this.addType(types);
    }

    public void addType(BiomeDictionary.Type ... types) {
        Collections.addAll(this.dictionaryTypes, types);
    }

    protected BiomeBuilder init() {
        this.dictionaryTypes.retainAll(BiomeDictionary.getTypes(this.parentKey));
        this.settings = new BiomeGenerationSettings.Builder();
        this.features.clear();
        this.settings.func_242517_a((ConfiguredSurfaceBuilder)this.parentBiome.func_242440_e().func_242500_d().get());
        this.func_242458_a(this.parentBiome.func_242433_b());
        this.func_205419_a(this.parentBiome.func_201856_r());
        this.parentBiome.func_242440_e().func_242487_a().forEach(s -> this.settings.func_242516_a((StructureFeature)s.get()));
        for (GenerationStage.Carving carving : GenerationStage.Carving.values()) {
            List carvers = this.parentBiome.func_242440_e().func_242489_a(carving);
            carvers.forEach(c -> this.settings.func_242512_a(stage, (ConfiguredCarver)c.get()));
        }
        for (GenerationStage.Carving carving : GenerationStage.Decoration.values()) {
            List features = (List)this.parentBiome.func_242440_e().func_242498_c().get(carving.ordinal());
            features.forEach(arg_0 -> this.lambda$init$4((GenerationStage.Decoration)carving, arg_0));
        }
        return this;
    }

    public void filterFeatures(DynamicMatcher ... filters) {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            List list = this.features.computeIfAbsent(stage, s -> new ArrayList());
            list.removeIf(f -> {
                ConfiguredFeature feature = (ConfiguredFeature)f.get();
                for (DynamicMatcher matcher : filters) {
                    if (!matcher.test(feature)) continue;
                    return true;
                }
                return false;
            });
        }
    }

    public void copyAmbience(RegistryKey<Biome> key) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_());
        if (biome == null) {
            return;
        }
        this.func_235097_a_(biome.func_235089_q_());
    }

    public Biome getBiome() {
        return this.parentBiome;
    }

    public BiomeGenerationSettings.Builder getSettings() {
        return this.settings;
    }

    public Biome func_242455_a() {
        this.func_242457_a(this.settings.func_242508_a());
        return super.func_242455_a();
    }

    public Biome build(RegistryKey<Biome> key) {
        this.features.forEach((stage, list) -> list.forEach(f -> this.getSettings().func_242513_a(stage, (ConfiguredFeature)f.get())));
        this.func_242457_a(this.settings.func_242508_a());
        return (Biome)super.func_242455_a().setRegistryName(key.func_240901_a_());
    }

    private /* synthetic */ void lambda$init$4(GenerationStage.Decoration stage, Supplier f) {
        this.features.computeIfAbsent(stage, s -> new ArrayList()).add(f);
    }
}

